#include "SD_routines.h"
#include "FAT32.h"
#include "SPI_routines.h"
#include "uart_routines.h"

#include "FAT32.c"
#include "SD_routines.c"
#include "SPI_routines.c"
#include "uart_routines.c"


//  SD 
#define sdcard_init()  spi_init();card_init() ;unsigned char fileName[]="upload.bat";deleteFile(fileName)






void savechar(unsigned char *fileName, unsigned char *txt)
{
unsigned char j, o, data, error, fileCreatedFlag = 0, start = 0, appendFile = 0, sectorEndFlag = 0, sector;
unsigned int i, firstClusterHigh, firstClusterLow;
struct dir_Structure *dir;
unsigned long cluster, nextCluster, firstSector, clusterCount, extraMemory;
unsigned char subbuffer[512];
unsigned char fs;
fs=strlen(txt);
memcpy(subbuffer,txt,fs);


error = convertFileName (fileName); //convert fileName into FAT format
if(error) return;//Invalid file name
dir = findFiles (GET_FILE, fileName); //get the file location
if(dir!=0) return ;	//specified file name is already existing
cluster = getSetFreeCluster (NEXT_FREE, GET, 0);
if(cluster > totalClusters) cluster = rootCluster;
cluster = searchNextFreeCluster(cluster);
if(cluster == 0) return;//   No free cluster



getSetNextCluster(cluster, SET, EOF);   //last cluster of the file, marked EOF
firstClusterHigh = (unsigned int) ((cluster & 0xffff0000) >> 16 );
firstClusterLow = (unsigned int) ( cluster & 0x0000ffff);
fileSize = 0;
startBlock = getFirstSector (cluster);
i=0;
j=0;



	  fileSize=fs;

		memcpy(buffer,subbuffer,fs);


	  buffer[fileSize++]=13;
	  buffer[fileSize++]=10;


	  SD_writeSingleBlock (startBlock);






//executes following portion when new file is created




   firstSector = getFirstSector (rootCluster);

   for(sector = 0; sector < sectorPerCluster; sector++)
   {
     SD_readSingleBlock (firstSector + sector);
	

     for(i=0; i<bytesPerSector; i+=32)
     {
	    dir = (struct dir_Structure *) &buffer[i];

		if(fileCreatedFlag)   //to mark last directory entry with 0x00 (empty) mark
		 { 					  //indicating end of the directory file list
		   dir->name[0] = 0x00;
           return;
         }

        if((dir->name[0] == EMPTY) || (dir->name[0] == DELETED))  //looking for an empty slot to enter file info
		{
		  for(j=0; j<11; j++)
  			dir->name[j] = fileName[j];
		  dir->attrib = ATTR_ARCHIVE;	//settting file attribute as 'archive'
		  dir->NTreserved = 0;			//always set to 0
		  dir->timeTenth = 0;			//always set to 0
		  dir->createTime = 0x9684;		//fixed time of creation
		  dir->createDate = 0x3a37;		//fixed date of creation
		  dir->lastAccessDate = 0x3a37;	//fixed date of last access
		  dir->writeTime = 0x9684;		//fixed time of last write
		  dir->writeDate = 0x3a37;		//fixed date of last write
		  dir->firstClusterHI = firstClusterHigh;
		  dir->firstClusterLO = firstClusterLow;
		  dir->fileSize = fileSize;

		  SD_writeSingleBlock (firstSector + sector);
		  fileCreatedFlag = 1;

		  freeMemoryUpdate (REMOVE, fileSize); //updating free memory count in FSinfo sector
	     
        }
     }
   }


 




}


